﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class LineUI : MonoBehaviour
{
    public Image m_imageLine;//线
    public Image m_imageLineStart;
    public Image m_imageLineFinal;
    public void DrawLine(Vector3 startP, Vector3 finalP)
    {
        Vector3 varStart = startP;
        varStart.x = (varStart.x - Screen.width / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varStart.y = (varStart.y - Screen.height / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varStart.z = 0;
        Vector3 varFinal = finalP;
        varFinal.x = (varFinal.x - Screen.width / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varFinal.y = (varFinal.y - Screen.height / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varFinal.z = 0;
        Vector3 rightPosition = (varStart + varFinal) / 2;
        Vector3 rightRotation = varFinal - varStart;
        float HalfLength = Vector3.Distance(varStart, varFinal);
        //float LThickness = 0.1f;//线的粗细

        //创建圆柱体
        //GameObject MyLine = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.lineObj);
        m_imageLine.transform.localPosition = rightPosition;
        m_imageLine.transform.localRotation = Quaternion.FromToRotation(Vector3.up, rightRotation);
        Vector2 varSize = m_imageLine.rectTransform.sizeDelta;
        varSize.x = 250.0f;
        varSize.y = HalfLength;
        m_imageLine.rectTransform.sizeDelta = varSize;
        m_imageLineStart.transform.localPosition = varStart;
        m_imageLineFinal.transform.localPosition = varFinal;
    }
}
